<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="icon" href="/inventario/dist/img/favicon-32x32.png" sizes="32x32">
    <link rel="icon" href="/inventario/dist/img/favicon-96x96.png" sizes="96x96">

    <!-- Sweet Alert -->
     <script src="/inventario/dist/js/sweetalert2.min.js"></script>
     <link rel="stylesheet" href="/inventario/dist/css/sweetalert2.min.css">

    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/inventario/dist/css/normalize.css">
    <link rel="stylesheet" href="/inventario/dist/css/styles.css">   
    <link rel="stylesheet" href="/inventario/dist/css/all.min.css">
    

</head>
<body class="contenedor">

    <div class="contenedor-login">
        <div class="imagen-login">
            <img src="/inventario/dist/img/logo.png" alt="">
        </div>
        <p>Escriba los datos de usuario Microsip para iniciar sesión.</p>
        <hr>
        <form action="empresas.php" method="POST"> 
        <div class="form-usuario">
            <div class="campos">
                <div class="group-input">
                <label for="usuario"> Nombre de usuario </label>
                <input type="text" name="usuario" required>
                
                </div>
                <div class="group-input">   
                    <label for="conexion"> Conexión </label>
                    <select name="conexion" id="conexion" required>
                    <?php
                            $path ="include/xml/conexiones.xml";

                            if(file_exists($path)){
                            
                                $xml = new DOMDocument("1.0","UTF-8");
                                $xml-> load($path);
                                $nombres = $xml->getElementsByTagName("conexion");
                                foreach($nombres as $nombre){ 
                                    $nombre_conexion = $nombre->getElementsByTagName("nombre")->item(0)->nodeValue;
                                    ?>
                                    <option value="<?php echo $nombre_conexion?>"><?php echo $nombre_conexion?></option>
                               <?php }

                            }?>
  
                    </select>
                
                </div>        
                <div class="opciones">
                    <ul>
                        <li><a id="abrir_conexion"><i class="fas fa-folder-open"></i> Abrir Conexión</a></li>
                        <li><a href="#" id="nueva_conexion"><i class="fas fa-file"></i> Nueva Conexión</a></li>
                    </ul>
                </div>
                <div class="group-input"> 
                    <label for="password"> Contraseña</label>
                    <input type="password" autocomplete name="password" required>
                </div>
            </div>
            <div class="botones btn-aceptar">
                <button>Aceptar</button>
            </div>
        </div>
        </form>
        
    <input type="hidden" name="" id="valor_abrir">
    </div>
    <div class="logo">
      <img src="/inventario/dist/img/logo.png" alt="">
    </div>

 <?php 
    if(isset($_GET['nom'])){ 
        $nombre_con = $_GET['nom'];
        
        $path ="include/xml/conexiones.xml";

       if(file_exists($path)){
    
        $xml = new DOMDocument("1.0","UTF-8");
        $xml-> load($path);

        $datos = $xml->getElementsByTagName("conexion");

        $tipo_abrir ="";
        $servidor_abrir ="";
        $carpeta_abrir="";
 
        

        foreach($datos as $dato){
             $nombre = $dato->getElementsByTagName("nombre")->item(0)->nodeValue;
            if($nombre == $nombre_con){
                $tipo_abrir =$dato->getElementsByTagName("tipo")->item(0)->nodeValue;
                $servidor_abrir =$dato->getElementsByTagName("servidor")->item(0)->nodeValue;
                $carpeta_abrir =$dato->getElementsByTagName("carpeta")->item(0)->nodeValue;
            }

        }

    }

    ?>
    <form action="include/funciones/actualizar_xml.php" method="POST" >
        <div class="ventana_abrir_conexion" >
            <div class="info-ventana">
                <p>Abrir conexión</p>
                <a href="#" class="cerrar_ventana"><i class="fas fa-window-close"></i></a>
            </div>
         
            <div class="acomodar-form">
                <div class="grupos-abrir">
                    <div class="group-input"> 
                        <label for="tipo_conexion">Tipo de Conexión</label>
                        <select name="tipo_conexion" id="tipo_conexion">
                            <option value="local" <?php if($tipo_abrir == "local"){ echo "selected";} ?>>Local</option>
                            <option value="remota" <?php if($tipo_abrir == "remota"){ echo "selected";} ?>>Remota</option>
                        </select>
                    </div>
                    <div class="group-input"> 
                        <label for="nombre">Nombre</label>
                        <input type="text" name="nombre" id="nombre" readonly value="<?php echo $nombre_con ?>">
                    </div>
                    <div class="group-input"> 
                        <label id="label_servidor_abrir" for="servidor">Servidor</label>
                        <input type="text" name="servidor" id="servidor_abrir_conexion" value="<?php if($servidor_abrir !=null){ echo $servidor_abrir; } ?>">
                    </div>
                    <div class="group-input"> 
                        <label for="carpeta">Carpeta de datos</label>
                        <input type="text" name="carpeta" value="<?php echo $carpeta_abrir ?>">
                    </div>
                </div>
                <div class="botones btns-ventana">
                    <button type="submit">Aceptar</button>
                    <button type="button" id="cancelar_ventana">Cancelar</button>
                    <button type="button" onclick="eliminar('<?php echo $nombre_con ?>');">Eliminar..</button>
                </div>
        </div>
        </div>
    </form>
<?php } ?>

    <form action="include/funciones/agregar_xml.php" method="POST" >
    <div class="ventana_agregar_conexion" >
        <div class="info-ventana">
            <p>Nueva conexión</p>
            <a href="#" id="cerrar_ventana_agregar"><i class="fas fa-window-close"></i></a>
        </div>
        <div class="acomodar-form">
            <div class="grupos-abrir">
                <div class="group-input"> 
                    <label for="tipo_conexion_nueva">Tipo de Conexión</label>
                    <select name="tipo_conexion_nueva" id="tipo_conexion_nueva">
                        <option value="local" selected>Local</option>
                        <option value="remota">Remota</option>
                    </select>
                </div>
                <div class="group-input"> 
                    <label for="nombre_nuevo">Nombre</label>
                    <input type="text" name="nombre_nuevo" value="Local">
                </div>
                <div class="group-input"> 
                    <label id="label_servidor_nuevo" for="servidor_nuevo">Servidor</label>
                    <input type="text" name="servidor_nuevo" id="servidor_nuevo">
                </div>
                <div class="group-input"> 
                    <label for="carpeta_nueva">Carpeta de datos</label>
                    <input type="text" name="carpeta_nueva" value="C:\Microsip datos\">
                </div>
            </div>
            <div class="botones btns-ventana">
                <button type="submit">Aceptar</button>
                <button type="button" id="cancelar_ventana_agregar">Cancelar</button>
            </div>
       </div>
    </div>
    </form>
    
    <script src="dist/js/jquery.js"></script>
    <script src="dist/js/login.js"></script>
    <script src="dist/js/nueva_conexion.js"></script> 
    <script src="dist/js/abrir_conexion.js"></script>
    <?php 
      //ALERTAS

      if(isset($_GET['estatus'])){
        
          $respuesta = $_GET['estatus'];
         
        if($respuesta == "Eliminado"){
            echo "<script>";
            echo "
            Swal.fire({
            icon: 'success',
            title: 'Conexión Eliminada Correctamente',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            allowOutsideClick: true,      
            }).then((result) => {               
              if (result.value) {
                history.pushState({data:true}, '', 'index');     
              }
              history.pushState({data:true}, '', 'index');             
           })";
           echo "</script>";
        }
        if($respuesta == "Existente"){
            echo "<script>";
            echo "
            Swal.fire({
            icon: 'info',
            title: 'Ya existe una conexión con ese nombre',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            allowOutsideClick: true,      
            }).then((result) => {               
              if (result.value) {
                history.pushState({data:true}, '', 'index');     
              }
              history.pushState({data:true}, '', 'index');             
           })";
           echo "</script>";
        }
        if($respuesta == "Agregado"){
            echo "<script>";
            echo "
            Swal.fire({
            icon: 'success',
            title: 'Conexión Agregada Correctamente',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            allowOutsideClick: true,      
            }).then((result) => {               
              if (result.value) {
                history.pushState({data:true}, '', 'index');     
              }
              history.pushState({data:true}, '', 'index');             
           })";
           echo "</script>";
        }
        if($respuesta == "NoEliminado"){
            echo "<script>";
            echo "
            Swal.fire({
            icon: 'error',
            title: 'La Conexión no fue Eliminada',
            text: 'Intente nuevamente',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            allowOutsideClick: true,      
            }).then((result) => {               
              if (result.value) {
                history.pushState({data:true}, '', 'index');     
              }
              history.pushState({data:true}, '', 'index');             
           })";
            echo "</script>";
        }
        if($respuesta == "ErrorBD"){
            echo "<script>";
             echo "
             Swal.fire({
             icon: 'error',
             title: 'No fue posible establecer conexión con la base de datos',
             text: 'Asegurese de ingresar correctamente los datos',
             showConfirmButton: true,
             confirmButtonText: 'Aceptar',
             allowOutsideClick: true,      
             }).then((result) => {               
               if (result.value) {
                 history.pushState({data:true}, '', 'index');     
               }
               history.pushState({data:true}, '', 'index');             
            })";
             echo "</script>";
        }

        if($respuesta == "Actualizado"){
            echo "<script>";
             echo "
             Swal.fire({
             icon: 'success',
             title: 'Conexión Actualizada Correctamente',
             showConfirmButton: true,
             confirmButtonText: 'Aceptar',
             allowOutsideClick: true,      
             }).then((result) => {               
               if (result.value) {
                 history.pushState({data:true}, '', 'index');     
               }
               history.pushState({data:true}, '', 'index');             
            })";
             echo "</script>";
        }
      }
 
    ?>
</body>
</html>