<?php 
   include "header.php"; 
   require "../funciones/conexion_bd.php";
   require "../funciones/inventario_fisico/inventario_sqlite.php";

   $query_almacen= $conn->prepare("SELECT ALMACEN_ID,NOMBRE FROM almacenes ORDER BY nombre");
   $query_almacen->execute();
   $resultado_almacen = $query_almacen->fetchAll(PDO::FETCH_ASSOC);
   
?>


<main class="contenido-panel contenedor-inventarios fondo-panel">
    <h1>Inventario Físico</h1>
    <form id="form_seleccion" >
        <div class="contenedor-seleccion"> 
            <div class="grupo-inventario">
               <label for="colectora">N° Colectora</label>
               <input type="number" name="colectora" min="0" value="<?php if(isset( $_SESSION['colectora'])): echo  $_SESSION['colectora']; endif; ?>">  
            </div>
     
            <div class="grupo-inventario">
            <label for="almacen">Almacen</label>
            <select name="almacen" id="almacen">
                <?php foreach ($resultado_almacen as $resultado):?>
                  <option value="<?php echo $resultado['ALMACEN_ID'].",".$resultado['NOMBRE'] ?>" <?php if(isset($_SESSION['nombre_almacen'])): if($resultado['NOMBRE'] == $_SESSION['nombre_almacen']): echo "selected"; endif; endif;?> ><?php echo $resultado['NOMBRE'] ?></option>
                <?php endforeach; ?>
            </select>
            </div>
            <div class="contenedor-radios">
                <div class="inputs-radio">
                    <input type="radio" id="auto" name="tipo" value="automatico">
                    <label for="auto">Automático</label><br>
                </div>
                <div class="inputs-radio">
                    <input type="radio" id="manual" name="tipo" value="manual" checked>
                    <label for="manual">Manual</label><br>
                </div>        
            </div>
            <button id="btn_aceptar_seleccion" type="submit">Aceptar</button>
        </div>
    </form>

    <div class="contenedor-codigo">
        <div class="info-ventana">
                <p>Codigos de barra</p>
                <button id="cerrar_ventana_codigo"><i class="fas fa-window-close"></i></button>
        </div>
        <div class="contenido-codigo">
        
        <fieldset class="fieldset-informacion">
          <div class="informacion-seleccion">
               <div>
                   <label for="" class="label-almacen">Almacen: <span class="info-almacen"><?php // if(isset( $_SESSION['nombre_almacen'])): echo $_SESSION['nombre_almacen'];  endif;?></span> </label>
               </div>
               <div>
                   <label for="" class="label-colectora" >Colectora: <span class="info-colectora"><?php // if(isset( $_SESSION['colectora'])): echo $_SESSION['colectora'];  endif;?></span></label>

               </div>
            </div>
        </fieldset>
  

            <div class="dividir-inputs">
                <div class="input-articulo">
                    <label for="articulo">Código</label>
                    <div class="group-barcode">
                        <i class="fa fa-barcode"></i>
                        <input type="text" name="articulo" id="input_codigo" autocomplete="off" onchange="buscarArticulo();" >
                    </div>
                </div>

                <div class="input-posicion">
                    <label for="posicion">Posición</label>
                    <input type="text" name="posicion"  id="input_posicion" onkeypress="return !(event.charCode == 46)">
                </div>
            </div>
    
            <div class="contenedor-info ">
                <table id="tabla_codigo" class="table datos-tabla table-striped table-bordered table-sm cell-border " style="width: 100%;">
                   <thead class="thead-dark ancho-thead">
                     <tr>
                        <th>Posición</th>
                        <th>Nombre</th>
                        <th>Unidades</th>
                     </tr>
                   </thead>              
                </table>
            </div>
        </div>
    </div>

    <div id="contenedor_lector" class="contenedor-lector-codigo">
        <div class="contenido-lector"> 
            <div class="btn-cerrar-lector">
                <button id="cerrar_ventana_lector"><i class="fas fa-times"></i></button>
            </div> 
            <form id="form_lector">
                <div class="grupo-lector">
                    <label for="nombre">Nombre</label>
                    <input type="text" name="nombre_articulo" id="nombre_articulo" readonly>
                </div>
        
                <div class="grupo-lector">
                    <label for="unidades">Unidades</label>
                    <div class="flex-unidades">
                        <input id="unidades" type="number" name= "unidades" placeholder="Cant. de unidades" step="0.001" max="999999">
                        <span class="unidad_medida">pz</span>
                    </div>
                </div>
            
                <div class="btns-lector">
                    <button type="submit" id="btn_guardar_unidades"  value="Submit" >Aceptar</button>
                    <button type="button" id="btn_cancelar_lector">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
</main>

<script src="../../dist/js/datatables.js"></script>
<script src="../../dist/js/inventarios.js"></script>

<?php include "footer.php"; ?>