<?php 

session_start();
require "../conexion_bd.php";
require "inventario_sqlite.php";

//header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");


if(isset($_POST['unidades']) && isset($_POST['nombre_articulo'])){

    $nombre_articulo = $_POST['nombre_articulo'];
    $total_unidades = floatval($_POST['unidades']);

    if($total_unidades < 999999){
        
        //variables GLOBALES
        $docto_invfis_id = intval($_SESSION['docto_invfis_id']);
        $articulo_id =  intval($_SESSION['articulo_id']);
        $clave_articulo = $_SESSION['clave_articulo'];
        $posicion = $_SESSION['posicion'];
        $colectora = $_SESSION['colectora'];
        $automatico = $_SESSION['tipo'];

        //guardar unidades ingresadas en variable global
        $_SESSION['total_unidades'] = $total_unidades;
        $_SESSION['nombre_articulo'] = $nombre_articulo;

        $query_filtro = $conn->prepare("SELECT * FROM ng_doctos_infis_det (?,?)");
        $query_filtro ->bindParam(1, $docto_invfis_id, PDO::PARAM_INT);
        $query_filtro -> bindParam(2, $articulo_id, PDO::PARAM_INT);
        $query_filtro-> execute();
        $resultado_filtro = $query_filtro->fetchAll(PDO::FETCH_ASSOC);
        $query_count = $query_filtro->rowCount();


        if($query_filtro->rowCount() == 0){
          
                //consulta fecha
                $fecha_query = $conn->prepare("SELECT * FROM fecha_servidor;");
                $fecha_query ->execute();
                $resultado_fecha = $fecha_query->fetchAll(PDO::FETCH_ASSOC);
                $fecha =$resultado_fecha[0]['FECHA'];
                $hora = $resultado_fecha[0]['HORA'];
                $fecha = $fecha."".$hora; 
                $fecha = new DateTime($fecha);
                $fecha_hora =  $fecha->format("m/d/Y H:i:s");


                $query_insert_invfis_det = $conn->prepare("INSERT INTO DOCTOS_INVFIS_DET (Docto_invfis_det_id,docto_invfis_id,clave_articulo,articulo_id,unidades,posicion,terminal_id) 
                VALUES ((GEN_ID(id_doctos,1)), ?, ?, ?, ?, ?, ?) RETURNING docto_invfis_det_id");
                $query_insert_invfis_det ->bindParam(1,$docto_invfis_id);
                $query_insert_invfis_det ->bindParam(2,$clave_articulo);//clave articulo
                $query_insert_invfis_det ->bindParam(3,$articulo_id); //articulo_id
                $query_insert_invfis_det ->bindParam(4,$total_unidades);//unidades
                $query_insert_invfis_det ->bindParam(5,$posicion);//posicion
                $query_insert_invfis_det ->bindParam(6,$colectora);//terminal_id
                $query_insert_invfis_det ->execute();


                $query_insert_posicion = $conn->prepare("INSERT INTO DOCTOS_INVFIS_POSICION (Docto_invfis_pos_id,articulo_id,posicion,docto_invfis_id,terminal_id,unidades,fecha_hora_captura) 
                VALUES ((GEN_ID(id_doctos,1)), ?, ?, ?, ?, ?, ?)");
                $query_insert_posicion ->bindParam(1,$articulo_id);//articulo_id
                $query_insert_posicion ->bindParam(2,$posicion);//posicion
                $query_insert_posicion ->bindParam(3,$docto_invfis_id); //docto_invfis_id
                $query_insert_posicion ->bindParam(4,$colectora);//terminal_id
                $query_insert_posicion ->bindParam(5,$total_unidades);//unidades
                $query_insert_posicion ->bindParam(6,$fecha_hora);//fecha_hora_captura
                $query_insert_posicion ->execute();

                //insertar en tabla temporal
                insertar_temporal($colectora,$nombre_articulo,$docto_invfis_id,$posicion,$total_unidades,'N');

                echo json_encode("guardado_con_exito");

        }else{

              $query_posicion = $conn->prepare("SELECT * FROM NG_CM_doctos_invfis_posicion ( ?, ?, ?)");
              $query_posicion->bindParam(1,$docto_invfis_id);
              $query_posicion->bindParam(2,$posicion);
              $query_posicion->bindParam(3,$articulo_id);
              $query_posicion->execute();
              $resultado_posicion = $query_posicion->fetchAll(PDO::FETCH_ASSOC);
   
        
               if(isset($resultado_posicion[0]['POSICION'])){
                  $unidades_NG = $resultado_posicion[0]['UNIDADES'];
                  $_SESSION['unidades_NG'] = $unidades_NG;

                      if($resultado_posicion[0]["POSICION"] == $posicion){
                        if($resultado_posicion[0]["TERMINAL_ID"] == $colectora && $resultado_posicion[0]["ARTICULO_ID"]== $articulo_id ){
                          echo json_encode("articulo_ya_capturado"); //alert confirm para enviar a otro archivo
                        }else{
                            $mensaje= array(
                              "terminal_id" => $resultado_posicion[0]["TERMINAL_ID"],
                              "mensaje" => "posicion_capturada"
                            );
                            echo json_encode($mensaje);
                        }                    
                  }
               }else{
              
                  $query_filtro2 = $conn->prepare("SELECT * FROM doctos_invfis_posicion b WHERE b.articulo_id = ? AND b.docto_invfis_id = ?");
                  $query_filtro2->bindParam(1,$articulo_id);
                  $query_filtro2->bindParam(2, $docto_invfis_id);
                  $query_filtro2->execute();
                  $resultado_query_filtro2 = $query_filtro2->fetchAll(PDO::FETCH_ASSOC);
                   
                  $data = array();
                  
                  foreach($resultado_query_filtro2 as  $res){ 
                       $data[] =array(
                         "TERMINAL_ID" => $res['TERMINAL_ID'],
                         "POSICION" => $res['POSICION'],
                         "UNIDADES" => number_format(floatval($res['UNIDADES']),2),
                       );      
                  }

                  echo json_encode($data);
               }    
        }

    }else{
       echo json_encode('cantidad_mayor');
    }
}
?>