<?php
   
   session_start();
   require "../conexion_bd.php";
   require "inventario_sqlite.php";

  function alfanumerico($folio_str){

      $tamano = strlen($folio_str);
      $cadena1 ="";
      $cadena2 ="";
      $cadena3 ="";
      $consecutivo = 0;

      $letras = array(
         'A','B','C','D','E','F','G','H',
         'I','J','K','L','M','N','Ñ','O',
         'P','Q','R','S','T','U','V','W',
         'X','Y','Z','a','b','c','d','e',
         'f','g','h','i','j','k','l','m',
         'n','ñ','o','p','q','r','s','t',
         'u','v','w','x','y','z'
      );

      for ($i = 0; $i < $tamano; $i++) {
         if (in_array($folio_str[$i], $letras)) {
               $cadena1 = $cadena1.$folio_str[$i];
         }else{
               $cadena2 = $cadena2.$folio_str[$i];    
         }
      }
         $consecutivo = intval($cadena2);
         $consecutivo = $consecutivo + 1;

         $tamano = 9- (strlen(strval($consecutivo))+ strlen($cadena1));

            for ($i=0; $i < $tamano; $i++){
               $cadena3 = '0'.$cadena3;
            }
            
            $folio_str = $cadena1.$cadena3.strval($consecutivo);

            return $folio_str;
  }


  if(isset( $_POST['almacen']) && isset($_POST['colectora']) && isset($_POST['tipo'])){
   
   $almacen = $_POST['almacen'];
   $colectora = $_POST['colectora'];
   $tipo = $_POST['tipo'];

   $porciones_almacen = explode(",",$almacen);
   $almacen_id = $porciones_almacen[0];
   $almacen_nombre = $porciones_almacen[1];

   //Eliminar tabla temporal
   eliminar_invfis($colectora);

   $query = $conn->prepare("SELECT Docto_invfis_id FROM doctos_invfis a WHERE a.cancelado = 'N' AND a.aplicado = 'N' AND a.colectora= 'S' AND a.almacen_id = ? ;");
   $query ->bindParam(1,$almacen_id);
   $query ->execute();
   $resultados_datos = $query->fetchAll(PDO::FETCH_ASSOC);


   if($query->rowCount() > 0){   
  
      $docto_invfis_id = $resultados_datos[0]['DOCTO_INVFIS_ID'];

      $query = $conn->prepare("SELECT * FROM NG_doctos_invfis_det (?,?) a INNER JOIN articulos b ON (a.articulo_id = b.articulo_id);");
      $query ->bindParam(1,$docto_invfis_id);
      $query ->bindParam(2,$colectora);
      $query ->execute();
      $resultados_datos = $query->fetchAll(PDO::FETCH_ASSOC);

      foreach($resultados_datos as $resultado){
         insertar_temporal(
            $colectora,
            $resultado['NOMBRE'],
            $resultado['DOCTO_INVFIS_ID'],
            $resultado['POSICION'],
            $resultado['UNIDADES'],
            $resultado['SEGUIMIENTO']
         );
     }

      //envio de datos por json al FrontEnd
      $datos = array(
         "almacen_id" => $almacen_id,
         "nombre_almacen" => $almacen_nombre,
         "colectora"=> $colectora,
         "tipo" => $tipo
      );

      echo json_encode($datos);

      //Guardar datos en variables globales para su uso en otros archivos
      $_SESSION['colectora'] = $colectora;
      $_SESSION['nombre_almacen'] = $almacen_nombre;
      $_SESSION['almacen_id'] = $almacen_id;
      $_SESSION['docto_invfis_id'] = $docto_invfis_id;
     
       //Definir el tipo AUTOMATICO O MANUAL
         if($tipo == "automatico"){
           $_SESSION['tipo'] = true;
         }else{
           $_SESSION['tipo'] = false;
         }

   }else{
       
      //consulta valor
       $filtro2 = $conn->prepare("SELECT valor FROM registry a WHERE a.nombre = 'SIG_FOLIO_INVFIS';");
       $filtro2->execute();
       $resultado = $filtro2->fetchAll(PDO::FETCH_ASSOC);
       $valor = $resultado[0]['VALOR'];
  
       //consulta sucursal
       $sucursal_query = $conn->prepare("SELECT sucursal_id FROM sucursales");
       $sucursal_query ->execute();
       $resultado_sucursal= $sucursal_query->fetchAll(PDO::FETCH_ASSOC);
       $sucursal = $resultado_sucursal[0]['SUCURSAL_ID'];
       
       //consulta fecha
       $fecha_query = $conn->prepare("SELECT * FROM fecha_servidor;");
       $fecha_query ->execute();
       $resultado_fecha = $fecha_query->fetchAll(PDO::FETCH_ASSOC);
       $fecha =$resultado_fecha[0]['FECHA'];
       $fecha = new DateTime($fecha);
       $fecha =  $fecha->format("m/d/Y");
   
       if($tipo == "automatico"){
         $tipo = "S";
        }else{
         $tipo = "N";
        }

        $cancelado = "N";
        $aplicado = "N";
        $tipo_colectora ="S";

            $query_insert = $conn->prepare("INSERT INTO DOCTOS_INVFIS (DOCTO_INVFIS_ID, ALMACEN_ID, FOLIO, FECHA, CANCELADO, APLICADO, COLECTORA, AUTOMATICO, DESCRIPCION,SUCURSAL_ID) 
            VALUES (-1, ?, ?, ?, ?, ?, ?, ?, 'Conteo original', ?) RETURNING docto_invfis_id");
            $query_insert ->bindParam(1,$almacen_id);
            $query_insert ->bindParam(2,$valor);
            $query_insert ->bindParam(3,$fecha); 
            $query_insert ->bindParam(4,$cancelado);
            $query_insert ->bindParam(5,$aplicado);
            $query_insert ->bindParam(6,$tipo_colectora);
            $query_insert ->bindParam(7,$tipo); 
            $query_insert ->bindParam(8,$sucursal);
            $query_insert ->execute();
      
         $result = $query_insert->fetch(PDO::FETCH_ASSOC);
         $docto_invfis_id = $result["DOCTO_INVFIS_ID"];

         $_SESSION['docto_invfis_id'] = $docto_invfis_id;/////
        

         //incrementar el valor de folio
         $folio_str = alfanumerico($valor); //ejecutar funcion alfanumericos

         $update_query= $conn->prepare("UPDATE registry SET valor = ? WHERE nombre = 'SIG_FOLIO_INVFIS'");
         $update_query->bindParam(1,$folio_str);
         $update_query->execute();

         
        //envio de datos por json al FrontEnd
        $datos = array(
         "almacen_id" => $almacen_id,
         "nombre_almacen" => $almacen_nombre,
         "colectora"=> $colectora,
         "tipo" => $tipo
      );

       echo json_encode($datos);

      //Guardado de variables Sesiones
      $_SESSION['colectora'] = $colectora;
      $_SESSION['nombre_almacen'] = $almacen_nombre;
      $_SESSION['almacen_id'] = $almacen_id;

      //Definir el tipo AUTOMATICO O MANUAL
      if($tipo == "automatico"){
         $_SESSION['tipo'] = true;
      }else{
         $_SESSION['tipo'] = false;
      }

   }

     
 }