
//DATATABLE
var table = $("#tabla_codigo").DataTable({

        scrollCollapse: true,
        paging: false,
        ordering: false,
        info: false,
        searching: true,
        responsive: true,
        //retrieve: true,
        //bAutoWidth: true,
        scrollY: "230px",
        bprocessing: true,
        bServerSide: true,
        sAjaxSource: "../funciones/inventario_fisico/server_side/serversideInventario.php",
        "language" : {
            url: '../../dist/js/Spanish.json'
        },
        columnDefs:[{
            data: null
        }]

});


  //ventana seleccion (principal)
    let btn_aceptar_seleccion = document.getElementById("btn_aceptar_seleccion");
  //ventana codigos barra   
    let ventana_codigos_barra = document.querySelector(".contenedor-codigo");
     //text
      var input_codigo = document.getElementById("input_codigo");
      var input_posicion = document.getElementById("input_posicion");   
    //buttons 
      let btn_cerrar_codigos = document.getElementById("cerrar_ventana_codigo");   
  //ventana lector
      let ventana_lector = document.querySelector(".contenido-lector");
    //buttons 
       var btn_cerrar_lector = document.getElementById("cerrar_ventana_lector");
       var btn_cancelar_lector = document.getElementById("btn_cancelar_lector");
       var btn_aceptar_lector = document.getElementById("btn_guardar_unidades");
      

      //******** Eventos *********//
        btn_cerrar_codigos.addEventListener("click",function(){
            ventana_codigos_barra.style.display = "none";
            ventana_lector.style.display = "none";
            document.getElementById("unidades").value = "";
            input_posicion.value = "";
        
        });

        btn_cerrar_lector.addEventListener("click",function(){
            ventana_lector.style.display = "none";
            input_codigo.focus();
            document.getElementById("unidades").value = "";
        });
    
        btn_cancelar_lector.addEventListener("click",function(){
            ventana_lector.style.display = "none";
            input_codigo.focus();
            document.getElementById("unidades").value = "";
        });
    


   //FORMULARIO SELECCION
   var form_seleccion = document.getElementById("form_seleccion");

   form_seleccion.addEventListener('submit', function(e){
        e.preventDefault();

        var datos = new FormData(form_seleccion);
   
        if(datos.get('colectora') == "" || datos.get('colectora') == undefined || datos.get('almacen') == "" || datos.get('almacen') == undefined || datos.get('tipo') == "" || datos.get('tipo') == undefined){

            if(datos.get('colectora') == "" || datos.get('colectora') == undefined){
                Swal.fire({
                    title: 'Campo de colectora vacío',
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                });
            }
            if(datos.get('almacen') == "" || datos.get('almacen') == undefined){
                Swal.fire({
                    title: 'Campo de almacén vacío',
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                });
            }
            if(datos.get('tipo') == "" || datos.get('tipo') == undefined){
                Swal.fire({
                    title: 'Selecciona una opción Automático o Manual',
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                });
            }
        }else{

            var num_colectora = parseInt(datos.get('colectora'));


            if(!isNaN(num_colectora)){                
    
                fetch('../funciones/inventario_fisico/consultar_datos.php',{
                    method: 'POST',
                    body: datos
                }).then( response => response.json())
                .then(data => {

                    table.ajax.reload();

                    for (const property in data) {
                        if(property == "nombre_almacen"){
                            document.querySelector(".info-almacen").innerHTML = data[property];
                        }
                        if(property == "colectora"){
                            document.querySelector(".info-colectora").innerHTML = data[property];
                        }                 
                    }

                    ventana_codigos_barra.style.display = "block";  
                    
                    if( input_posicion.value == ""){
                        input_posicion.readOnly = false;
                    }

                    input_posicion.focus();
                });
            }else{
                Swal.fire({
                    title: 'Ingrese solo numeros en el campo colectora',
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                });
            }
        }

   });


   //agregar posicion al presionar enter pasar al campo de codigo de barras
   input_posicion.addEventListener('keydown', function(e){

        var keycode = (e.keyCode ? e.keyCode : e.which);
        if (keycode == '13') {

            if(input_posicion.value != ""){
               input_codigo.focus();
               input_posicion.readOnly = true;
            }
          
            e.preventDefault();
            return false;
        }
    });

    input_posicion.addEventListener('dblclick',function(){
        input_posicion.readOnly = false;
    });


    function buscarArticulo(){	

        var input_posicion = document.getElementById("input_posicion");   
        var input_codigo = document.getElementById("input_codigo");
      

        if(input_posicion.value != "" && input_posicion.value != undefined){
            let clave = input_codigo.value.trim();

            if( clave != ""){      

                    var dato = {
                        clave: input_codigo.value,
                        posicion: input_posicion.value
                     };

                    fetch("../funciones/inventario_fisico/codigo_barra.php", {
                      method: 'POST',
                      body: JSON.stringify(dato),

                    }).then(response => response.json())
                    .catch(error => console.log('Error:', error))
                    .then( data =>{

                        if(data == "articulo_no_existente"){
                            Swal.fire({
                                title: 'El articulo no esta dado de alta',
                                icon: 'error',
                                showCancelButton: false,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#3085d6',
                            });
                        }
                        if(data == "articulo_dado_baja"){
                            Swal.fire({
                                title: 'El articulo esta dado de baja',
                                icon: 'error',
                                showCancelButton: false,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#3085d6',
                            });
                        }

                        if(typeof(data) == "object"){
                            ventana_lector.style.display = "block";
                            document.getElementById("unidades").focus();
                            //  let nombre_articulo = document.getElementById("nombre_articulo");
                            //  let unidades = document.getElementById("unidades");

                             for (const property in data) {
                        
                                 if(property == "nombre_articulo"){
                                    document.getElementById("nombre_articulo").value = data[property];
                                 }
                                 if(property == "unidad_venta"){
                                    document.querySelector(".unidad_medida").innerHTML = data[property];
                                 }                 
                             }
                        }
                        input_codigo.value= "";    

                    });
              
            }else{
                Swal.fire({
                    title: 'campo de codigo vacío',
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                });
            }

           
        }else{
            Swal.fire({
                title: 'Inserte una posición',
                icon: 'error',
                showCancelButton: false,
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#3085d6',
            }).then((result) => {
        
                input_posicion.focus();
                return false;
            });
          
        }

    }

//FETCH guardar total de unidades introducidas

 form_lector = document.getElementById("form_lector");

    form_lector.addEventListener("submit", function(e){
        e.preventDefault();

        var datos = new FormData(form_lector);

        if(datos.get('unidades') != ""){
 
            if(!isNaN(datos.get('unidades'))){

                ventana_lector.style.display = "none";

                fetch("../funciones/inventario_fisico/guardar_unidades.php",{
                    method: 'POST',
                    body: datos,

                }).then((response) => response.json())
                .then(data =>{                
                

                    //recargar datatable
                    if(data == "guardado_con_exito"){
                        ventana_lector.style.display = "none";
                        document.getElementById("unidades").value = "";
                        input_codigo.focus();

                        table.ajax.reload();
                    }
                    
                    if(data == "cantidad_mayor"){
                        Swal.fire({
                            title: 'La cantidad es mayor a 999,999',
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#3085d6',
                        });
                    }

                    //Alert Confirm
                    if(data == "articulo_ya_capturado"){
                        Swal.fire({
                            title: 'El articulo ya fue capturado en esta posicion ¿Deseas agregarlo?',
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Si',
                            cancelButtonText: "No",
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                        }).then((result) => {
                            if (result.value) {         
                                fetch("../funciones/inventario_fisico/modificar_unidades.php",{
                                   method: 'POST',
                                   body: result
                                }).then(response => response.json())
                                .catch(error => console.log('Error:', error))
                                .then(data => {
                          
                                    if(data == "modificado_con_exito"){
                                        table.ajax.reload();
                                        ventana_lector.style.display = "none";
                                        document.getElementById("unidades").value = "";
                                        input_codigo.focus();
                                    }
                                });
                            }else{
                                ventana_lector.style.display = "none";
                                input_codigo.focus();
                            }
                            return false;
                        })
                    }

                    if(typeof(data) == "object"){     

                        if(data.mensaje == "posicion_capturada"){
                            Swal.fire({
                                title: 'Esta posicion fue capturada por la terminal: \n' + data.terminal_id,
                                icon: 'warning',
                                showCancelButton: false,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#3085d6',
                            });
                            ventana_lector.style.display = "none";
                            input_codigo.focus();

                        }else{
                
                            let count = data.length;
                            data = Object.assign({}, data); 

                            let tabla = `
                             <h2 class='titulo-sweetalert'>Este artículo ya fue capturado por las siguientes terminales, ¿Desea adjuntarlo? </h2>
                            <div class='contenedor-tabla-sweetalert'> 
                            <table class='table tabla-sweetalert' > 
                            <thead class='thead-dark'> 
                            <tr>
                                <th>Terminal</th>
                                <th>Posición</th>
                                <th>Unidades</th>
                            </tr>
                            </thead>
                            <tbody> 
                            `;

                            for (const property in data) {
                                let inf = data[property];
                                tabla +=  `<tr>`;

                                for(const key in inf){
                                    if(key == "TERMINAL_ID"){
                                        tabla += "<td>"+ inf[key] + "</td>";
                                    }
                                    if(key == "POSICION"){
                                        tabla += "<td>"+ inf[key] + "</td>";
                                    }
                                    if(key == "UNIDADES"){
                                        tabla += "<td>"+  Number.parseFloat(inf[key]).toFixed(2) + "</td>";
                                    }
                                }
                                tabla += `</tr>`;  
                            }
                            tabla += `</tbody> </table> </div>`;
                        
                            //ALERTA
                            Swal.fire({
                                html: tabla,
                                showCancelButton: true,
                                confirmButtonText: 'Aceptar',
                                cancelButtonText: "Cancelar",
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                            }).then((result) => {
                            if (result.value) {         
                                fetch("../funciones/inventario_fisico/adjuntar_articulo.php",{
                                   method: 'POST',
                                   body: result
                                }).then(response => response.json())
                                .then(data => {
                                
                                    if(data == "modificacion_con_exito"){

                                        table.ajax.reload();
                                        ventana_lector.style.display = "none";
                                        document.getElementById("unidades").value = "";
                                        input_codigo.focus();
                                    }
                                });
                            }else{
                                ventana_lector.style.display = "none";
                                input_codigo.focus();
                            }
                            return false;
                        })

                        }
                    }
                     
             });

           }else{
                Swal.fire({
                    title: 'Inserta solo datos numéricos',
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                });
           }
        }else{
            Swal.fire({
                title: 'El campo de unidades no puede ir vacío',
                icon: 'error',
                showCancelButton: false,
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#3085d6',
            });
        }
     
    });


